Please see the SDD for service dependencies.

## Build

```
<ENV=VAL...> ./build.sh
```

The following environment variables are optional, but can be prepended to the command as documented above.
1. BUILD_DIR: output directory for artifacts (default: ./build)
2. STAGING_DIR: directory for intermediate build and packaging (default: ./dist)
3. DTR_PREFIX: prefix for target Docker trusted registry (only read is currently needed, default: blank)
4. DTR_ORG: organization label for target Docker trusted registry (only read is currently needed, default: blank)
5. BUILD_NUMBER: build number
6. APPDATE: build date

Note for developers: leaving both DTR_PREFIX and DTR_ORG blank will default the build to use the source docker image at dev/image.  This can be done when building out the images manually and automatically tagging to the local dev registry.

## Running Locally

1. Build the *centos7-base* docker image
2. Build the *centos7-nginx* docker image
3. Run `source app.env`
4. Run `build.sh`
5. From *dist* folder, run `docker build -t dev/var-web .`
6. Run `docker run -p 80:80 dev/var-web` -- this step will run without the innovations environment setup
7. Open browser and navigate to `http://localhost/veteran-appointment-requests` to see VAR

## Instructions to integrate var-web with the innovations stack

1. Add the following section of code to the docker-compose.yml file in the dockerlocal_development stack
(Take care to notice the spacing as yaml is space sensitive)

```
 var-web:
    image: dev/var-web
    ports:
    - "9090:80"
    environment:
    - SERVICE_TAGS=local
    - SERVICE_NAME=var-web
```

2. Add the curl command to the run.sh file in the dockerlocal_development stack

```
curl -H "X-Consul-Token: 7BE784A4-7498-4469-BE2F-9C3B9444DFEF" -s -X PUT localhost:8500/v1/kv/vamf/local/apigateway/1.0/services/var -d '{"location":"/veteran-appointment-requests","service":"var-web","redirect":"off","headers":{"X-Real-IP":"$remote_addr"}}' > /dev/null
```

3. To view changes while working in the innovation stack:
    1. Run these two commands in the terminal at the root of this repo
        1. Run `build.sh`
        2. From *dist* folder, run `docker build -t dev/var-web .`
    2. Run these two commands in the terminal at the docker-local-development directory
        1. `docker-compose kill var-web`
        2. `docker-compose up -d var-web`
